﻿///<summary>Helper function: Opens a window for a new Recurring Appointment record using the Information form.</summary>
///<param name="subject" optional="false" type="String">
///Subject associated with the recurring appointment series.
///</param>
///<param name="cvt_serviceactivityid" optional="false" type="String">
///Unique identifier for Service Activity associated with Recurring Appointment. Expected value is a String that matches the pattern for a GUID '/^{?[A-Z0-9]{8}-[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{12}}?$/i'.
///</param>
///<param name="cvt_serviceactivityidname" optional="false" type="String">
///The text to display for the record represented by the cvt_serviceactivityid parameter.
///</param>
function openNewRecurringAppointmentMaster(subject, serviceActivityID, serviceActivityName) {
    if ((typeof Xrm != "undefined") && (typeof Xrm.Utility != "undefined")) {
        var p = {};
        p.formid = "4a8cda55-024e-419c-bbe1-9540e0b8e297"
        p.subject = subject;
        p.cvt_serviceactivityid = serviceActivityID;
        p.cvt_serviceactivityidname = serviceActivityName;
        Xrm.Utility.openEntityForm("recurringappointmentmaster", null, p);
    }
    else {
        var features = "location=no,menubar=no,status=no,toolbar=no,resizable=yes";
        var extraqs = ["formid=4a8cda55-024e-419c-bbe1-9540e0b8e297",
        "subject=" + subject,
        "cvt_serviceactivityid=" + serviceActivityID,
        "cvt_serviceactivityidname=" + serviceActivityName]
        var url = Xrm.Page.context.getServerUrl();
        if (url.match(/\/$/)) {
            url = url.substring(0, url.length - 1);
        }
        if (typeof Xrm.Page.context.getClientUrl != "undefined") {
            url = Xrm.Page.context.getClientUrl();
        }
        window.open(url + "/main.aspx?etn=recurringappointmentmaster&pagetype=entityrecord&extraqs=" + encodeURIComponent(extraqs.join("&")), "_blank", features, false);
    }
}

//Functions Called by Ribbon Buttons
//Example:
//Calls openNewRecurringAppointmentMaster - called by Ribbon Button "Recurring Service Activity"
function CreateRecurringServiceActivity() {
    var serviceActivityName = "Recurring " + Xrm.Page.getAttribute("subject").getValue();
    openNewRecurringAppointmentMaster(serviceActivityName, Xrm.Page.data.entity.getId(), serviceActivityName)
}

//Open Recurring Appointment Master Record - called by Ribbon Button "Edit Series"
EditServiceActivitySeries = function () {
    var relatedMaster = Xrm.Page.getAttribute("cvt_recurringappointmentsmaster").getValue();
    if (relatedMaster != null)
        Xrm.Utility.openEntityForm("recurringappointmentmaster", relatedMaster[0].id)
}

ReOpenServiceActivity = function () {
    var isDataAdmin = MCS.cvt_Common.userHasRoles("TSS Data Administrator|System Administrator|TSS Application Administrator")
    if (isDataAdmin || Xrm.Page.getAttribute("ownerid").getValue()[0].id == Xrm.Page.context.getUserId())
        Mscrm.CommandBarActions.activate(Xrm.Page.data.entity.getId(), Xrm.Page.data.entity.getEntityName());
    else 
        MCS.cvt_Common.openDialogOnCurrentRecord("00520409-98FB-4A1E-B67C-D3D6783ACB84");    
} 